﻿#pragma once
//ESTRUCTURAS EXPUESTAS AL EXTERIOR
#include <ATcrt/AT_inttypes.h>
#include <ATcrt/ATarrays.h>
#include "ClasesGenericas.h"
#include <AT2D3D/AT2D3D.h>

#ifndef Index
#define Index AT2D3D_Index
#endif

typedef struct{
	Puntoxyn_BODY(double)
	umint bb;
} Puntof;
defineVector(Puntof)

typedef struct{
	Index;
	uint pf;
	Puntoxy_float p;
} Pesopf;
defineVector(Pesopf)

typedef struct{
	Index;
	double focal;
	umint b;
	Vector_Puntof puntos;
} Fotograma;

typedef PuntoXYZ_float PesoP;
#define defaultvalues_pesoP(peso) \
	(peso).Z=(peso).Y=(peso).X=1.0F

typedef struct{
	PuntoXYZn_BODY(double)
	umint bbb;
	uint peso;	//!=0 si apunta a algún peso
} PuntoM;
#define default_values_PM(PM) \
	(PM).bbb=7, (PM).peso=0

typedef struct{
	PesoP p;
	PesoP g;
} PesoCP;
#define defaultvalues_pesoCP(peso) \
	(peso).p.Z=(peso).p.Y=(peso).p.X=1.0F;\
	(peso).g=(peso).p

typedef struct{
	union{uint index; char8_t *nom; Fotograma *fot;};
	PuntoXYZM_BODY(double)
	umint gggppp;
	umint gggppp2;
	umint b;
	uint peso;	//!=0 si apunta a algún peso
} CentroProy;
#define default_values_CP(c) \
	(c).b=1;\
	(c).gggppp=077;\
	(c).gggppp2=0;\
	(c).peso=0

defineVector(Fotograma)
defineVector(PesoP)
defineVector(PesoCP)
defineVector(PuntoM)
defineVector(CentroProy)
